/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.serialization.Codec;
import io.github.frqnny.mostructures.structure.ConfigMS;
import io.github.frqnny.mostructures.structure.StructurePoolBasedGenerator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6834;
import net.minecraft.class_7059;

public class ModStructure
extends class_3195<ConfigMS> {
    public ModStructure() {
        this(0);
    }

    public ModStructure(int structureStartY) {
        this(structureStartY, true, true);
    }

    public ModStructure(int structureStartY, boolean modifyBoundingBox, boolean surface) {
        this(ConfigMS.CODEC, structureStartY, modifyBoundingBox, surface, ModStructure::canGenerate);
    }

    public ModStructure(Codec<ConfigMS> codec, int structureStartY, boolean modifyBoundingBox, boolean surface, Predicate<class_6834.class_6835<ConfigMS>> predicate) {
        super(codec, context -> {
            if (!predicate.test(context)) {
                return Optional.empty();
            }
            class_2338 blockPos = new class_2338(context.comp_309().method_8326(), structureStartY, context.comp_309().method_8328());
            return StructurePoolBasedGenerator.generate((class_6834.class_6835<ConfigMS>)context, class_3790::new, blockPos, modifyBoundingBox, surface);
        });
    }

    public static boolean canGenerate(class_6834.class_6835<ConfigMS> context) {
        return ModStructure.checks(context.comp_306(), context.comp_308(), context.comp_309(), (ConfigMS)context.comp_310(), context.comp_311());
    }

    public static boolean checks(class_2794 chunkGenerator, long worldSeed, class_1923 pos, ConfigMS config, class_5539 world) {
        for (class_5321<class_7059> key : config.structureSetToAvoid) {
            if (!chunkGenerator.method_41053(key, worldSeed, pos.field_9181, pos.field_9180, 3)) continue;
            return false;
        }
        int heightRange = config.heightRange;
        if (heightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = pos.field_9181 - 2; curChunkX <= pos.field_9181 + 2; ++curChunkX) {
                for (int curChunkZ = pos.field_9180 - 2; curChunkZ <= pos.field_9180 + 2; ++curChunkZ) {
                    int height = chunkGenerator.method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, class_2902.class_2903.field_13194, world);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                }
            }
            return maxTerrainHeight - minTerrainHeight <= heightRange;
        }
        return true;
    }
}

